# ##############################################################
# cosinuss° LabServer - API Example Script
# date      10.06.2021
# ########################################
# This script downloads all data of all persons that will be provided in person_hash_list and stores it into
# the /data_files_persons folder where this script is placed.

import json
import pandas as pd
from pathlib import Path
from API_requests_helper import API_USER

base_url = 'https://telecovid.earconnect.de/api/v3/'


# Insert the login data as string here
username = ''
password = ''

# provide person hash_id
# you can add more persons like: ['XYK1.74BM', 'XYK1.73CM']
person_hash_list = ['0RFM.99W7']

# optionally: provide only specific data types that you want to download
# data_types_list = ['heart_rate', 'spo2', 'temperature']
data_types_list = ['heart_rate', 'spo2', 'temperature']


if not username or not password:
    print('Error: Please specify username and password first!')
    exit()

api = API_USER()
api.login(username=username, password=password, server=base_url)

for person_hash_id in person_hash_list:

    # download the data files for every person in the project
    data_file_list = api.download_list_of_data_files_for_person(person_hash_id)

    # optional:
    # get person event of the current person using its hash and put it into a dictionary
    person_events_dic = {
        'events': api.person_events_for_person(person_hash_id)
    }
    if person_events_dic['events']:
        person_events_file_name = f'{api.storage_path_persons_df / person_hash_id}_person_events.json'
        json.dump(person_events_dic, open(person_events_file_name, 'w'), default=str, indent=4)

    # iterate through all the files of this person...
    for data_file_hash in data_file_list:

        # download the meta information
        meta_dic = api.download_meta_data_of_data_file(data_file_hash)

        date_string = str(meta_dic["date_time_start"]).replace(' ', '_').replace(',', '').replace(':', '-')[:23]

        # store meta information
        json.dump(meta_dic, open(f'{api.storage_path_persons_df / person_hash_id}_{date_string}_meta.json', 'w'), default=str, indent=4)
        # download only files which have some data
        if meta_dic['duration'] > 0:

            # download all data types available
            for data_type in meta_dic['cols']:

                # it the data_types_list exists then continue if the current data_type is not in the data_types_list
                if data_types_list and data_type not in data_types_list:
                    continue

                # create the file name with the date
                foldername = f'{api.storage_path_persons_df / person_hash_id}'
                if not Path(foldername).exists():
                    Path(foldername).mkdir()
                filename = f'{api.storage_path_persons_df / person_hash_id / person_hash_id}_{date_string}_{data_type}.csv'

                # do not download the data again
                if Path(filename).exists():
                    print(f'skipping {data_type} of person {person_hash_id} since it is already downloaded')
                    continue

                x, y = api.download_data_type_of_data_file(data_file_hash, data_type)
                # now you can do something with the data ...

                # store as csv
                csv_data = pd.DataFrame({'x': x, 'y': y})
                csv_data.to_csv(filename, index=False)

                # Example Plot
                # try:
                #     from matplotlib import pyplot as plt
                #
                #     plt.plot(x,y, label=f'heart_rate - Person: {person_hash_id}, Data File {data_file_hash}')
                #     plt.legend()
                #     plt.show()
                #
                # except ModuleNotFoundError:
                #
                #     print('Please install matplotlib to plot the data')
                #     pass

        else:
            print(f'Skipped data file {data_file_hash} because it contained no data.')

print('----- DONE -----')