# server_api_example

server_api_example folder consists of Python scripts for interacting with the lab_server api.
if you are familiar with python syntax, then it is fairly easy to work with the scripts.

An alternative would be to use the "curl command", which has been covered already in  [api_help](https://wiki.earconnect.de/public/api_help)


## Installation

It is required to have the latest version of python installed on your system.
If you do not have python on your system, you can install it [here](https://www.python.org/downloads/). 
please follow their instruction for installation depending on your operating system. 

if you have windows as your operating system, then you need to also add python to PATH on your system as described in details [here](https://docs.python.org/3/using/windows.html).  

In addition, installation of python packages are also required, which can be done easily using pip or pip3 for installation(depending on your operating system).

```bash
pip3 install python-jose 
pip3 install pandas 
pip3 install pathlib 
pip3 install requests 
```
In case you also want to plot the data, then you also need to pip or pip3 install matplotlib as well:

```bash
pip3 install matplotlib 
```

## Usage

The zip file is downloaded and extracted in the desired path. Now, for different cases, you can choose which script to execute. 

if you want to download and store all the data files that are created for your scope, then please run the dl_all_data_files.py:

```bash
python3 dl_all_data_files.py # stores all data files in .../server_api_example_script/data_files
```

all data files for the scope, will be stored in a folder named data_files, as csv files.

maybe you would like to just download created data files for one or more specific persons in the project, then you can run the dl_all_df_person_hash instead

```bash
python3 dl_all_df_person_hash.py # stores all data files in .../server_api_example_script/data_files_persons
```
the data files can be found in the data_files_persons folder. 

The script will not download the same data twice unless you delete the
corresponding file again. Therefore, pay attention if the data file is from
the same day and new data is still being recorded. You can change the code
or make your own code to avoid this.

provide each script with username and password of your own account ID and password. Make sure that your username is assigned to all projects, otherwise the
returned x and y values will be empty.

## contact 
any feedback would be welcome. We encourage you to also visit our [documentation and user manuals](https://wiki.earconnect.de/public/start) 
If you have any issues or questions, you can contact your supervisor via email. We will get in touch as soon as possible. 


## License
All rights reserved [Cosinuss GmbH](https://www.cosinuss.com/en/)