# ##############################################################
# cosinuss° LabServer - API Example Script
# date      10.06.2021
# ########################################
# This script is the helper class contains methods that can be called for downloading data

import requests
import json
from pathlib import Path
from jose import jwt
from datetime import datetime, timedelta



class API_USER():

    def __init__(self, username=None, password=None, server=None):

        self.username = username
        self.password = password
        self.server = server
        self.token_dic = None

        # Storage Path - path relative to the folder of this script
        self.storage_path_all_df = Path('data_files')
        if not self.storage_path_all_df.exists():
            self.storage_path_all_df.mkdir()

        # Storage Path - path relative to the folder of this script
        self.storage_path_persons_df = Path('data_files_persons')
        if not self.storage_path_persons_df.exists():
            self.storage_path_persons_df.mkdir()

        if username and password:
            self.login(username=self.username, password=self.password, server=self.server)

    def login(self, username=None, password=None, server=None):

        if username and password:

            self.username = username
            self.password = password
            self.server = server

            response = requests.get(self.server + 'login', headers={'username': self.username, 'password': self.password})

            if response.status_code == 200:

                response_str = response.content.decode()
                x_auth_token = json.loads(response_str)['x_auth_token']
                x_auth_token_expire = datetime.fromtimestamp(jwt.get_unverified_claims(x_auth_token)['exp'])
                print(('successful login, it expires ' + str(x_auth_token_expire) + ' expiring in ' +
                       str(round((x_auth_token_expire - datetime.now()).total_seconds() / 60, 1))) + ' min')

                self.token_dic = {
                    'x_auth_token': x_auth_token,
                    'x_auth_token_expire': x_auth_token_expire
                }

                json.dump(self.token_dic, open('token.tmp', 'w'), default=str)

            else:
                print(f'Server status code: {response.status_code}')
                return False

        else:
            print('please check if you have correctly enter your account ID and password')


    def check_token(self):

        try:
            self.token_dic = json.load(open('token.tmp'))
            x_auth_token = self.token_dic['x_auth_token']
            x_auth_token_expire = datetime.strptime(self.token_dic['x_auth_token_expire'], '%Y-%m-%d %H:%M:%S')
        except (FileNotFoundError, json.decoder.JSONDecodeError):
            self.token_dic = {}
            x_auth_token = None
            x_auth_token_expire = None

        if not x_auth_token or x_auth_token_expire - timedelta(seconds=120) < datetime.now():

            self.login(username=self.username, password=self.password, server=self.server)


    def download_list_of_all_data_files_available(self):
        # https://telecovid.earconnect.de/api/v3/data_files

        self.check_token()

        print(f'\ndownload a list of all data files')
        # curl -H "X-AUTH-TOKEN: temporary.secret.token" https://telecovid.earconnect.de/api/v3/data_files
        response = requests.get(self.server + f'data_files',
                                headers={'X-AUTH-TOKEN': self.token_dic['x_auth_token']})

        if response.status_code == 200:

            result_dic = json.loads(response.content.decode())

            print('\nThe following datafiles were found:')

            for df_hash_id in result_dic['data']:
                print(df_hash_id)

            return result_dic['data']

        else:

            print(
                f'\ndownload a list of all data files failed. Status code: {response.status_code}')
            return []


    def download_list_of_data_files_for_person(self, person_hash):

        self.check_token()

        print(f'\ndownload a list of all data files for person {person_hash}')
        # curl -H "X-AUTH-TOKEN: temporary.secret.token" https://telecovid.earconnect.de/api/v3/person/<person id>/data_files
        response = requests.get(self.server + f'person/{person_hash}/data_files',
                                headers={'X-AUTH-TOKEN': self.token_dic['x_auth_token']})

        if response.status_code == 200:

            result_dic = json.loads(response.content.decode())

            print(f'\nThe following data files were found for person {person_hash}:')

            for df_hash_id in result_dic['result']:
                print(df_hash_id)

            return result_dic['result']

        else:

            print(f'\ndownload a list of all data files for person {person_hash} failed. Status code: {response.status_code}')
            return []


    def download_meta_data_of_data_file(self, data_file_hash):

        self.check_token()

        print(f'\ndownload meta data for data file {data_file_hash}')

        # curl -H "X-AUTH-TOKEN: temporary.secret.token" https://telecovid.earconnect.de/api/v3/data_file/<data file id>/meta
        response = requests.get(self.server + f'data_file/{data_file_hash}/meta',
                                headers={'X-AUTH-TOKEN': self.token_dic['x_auth_token']})

        if response.status_code == 200:
            result_dic = json.loads(response.content.decode())['data']
            print(result_dic)
            print(json.dumps(result_dic, indent=4))

            return result_dic

        else:
            print(f'\ndownload meta data for data file {data_file_hash} failed. Status code: {response.status_code}')
            return {}



    def download_data_type_of_data_file(self, data_file_hash, data_type):

        self.check_token()

        print(f'\ndownload {data_type} data for data file {data_file_hash}')

        # curl -H "X-AUTH-TOKEN: temporary.secret.token" https://telecovid.earconnect.de/api/v3/data_file/<data file id>/<data type>/data
        response = requests.get(self.server + f'data_file/{data_file_hash}/{data_type}/data',
                                headers={'X-AUTH-TOKEN': self.token_dic['x_auth_token']})

        if response.status_code == 200:
            result_dic = json.loads(response.content.decode())
            # print(result_dic)

            x = result_dic['data']['x']
            y = result_dic['data']['y']

            # print('x: ', x)
            # print('y: ', y)

            return x, y

        else:

            print(f'\ndownload data for data file {data_file_hash} failed. Status code: {response.status_code}')
            return [], []



    def person_events_for_person(self, person_hash):

        self.check_token()
        response = requests.get(self.server + f'person_events/person/{person_hash}', headers={'X-AUTH-TOKEN': self.token_dic['x_auth_token']})

        if response.status_code == 200:
            response_dict = json.loads(response.content.decode())
            person_events = response_dict['data']
            print(f'The following person events were found for {person_hash}:')
        else:
            person_events = []
            print(f'No person events found for {person_hash}')

        for pe in person_events:
            print(pe)

        return person_events

    def download_list_of_data_files_for_person(self, person_hash):
        print(f'\ndownload a list of all data files for person {person_hash}')
        # curl -H "X-AUTH-TOKEN: temporary.secret.token" https://telecovid.earconnect.de/api/v3/data_files/person/<person id>
        response = requests.get(self.server + f'/data_files/person/{person_hash}',
                                headers={'X-AUTH-TOKEN': self.token_dic['x_auth_token']})

        if response.status_code == 200:

            result_dic = json.loads(response.content.decode())

            print(f'\nThe following data files were found for person {person_hash}:')

            for df_hash_id in result_dic['data']:
                print(df_hash_id)

            return result_dic['data']

        else:

            print(f'\ndownload a list of all data files for person {person_hash} failed. Status code: {response.status_code}')
            return []