#!/usr/bin/env python3

from datetime import datetime, timedelta
from cosinuss.api_client import APIClient

# ##########################################
# CONFIG
username = 'user.account'
password = 'xxx'
# ##########################################

# create api with username and password
#api = APIClient(username=username, password=password)
# create api with username only (password prompt)
api = APIClient(username=username)

print('\n' + 60*'#')
print('get a list of all project hashes')
project_hash_list = api.projects()
print('project_hash_list[:5]:', '\n\t', project_hash_list[:5])

print('\n' + 60*'#')
print('get a list of all people hashes')
people_hash_list = api.people()
print('people_hash_list[-5:]:', '\n\t', people_hash_list[-5:])

print('\n' + 60*'#')
print('get a list of all people hashes for the first project in project_hash_list')
people_hash_list = []
if project_hash_list:
    people_hash_list = api.people(project=project_hash_list[0])
    print('people_hash_list[:5]:', '\n\t', people_hash_list[:5])

print('\n' + 60*'#')
print('get meta data of firt person in people_hash_list')
if people_hash_list:
    person_meta = api.person_meta(person=people_hash_list[0])
    print('person_meta:', '\n\t', person_meta)

print('\n' + 60*'#')
print('get meta data of all people for the first project in project_hash_list')
print('loop people_meta:')
for person in api.people_meta(project=project_hash_list[0])[:5]:
    print('\t', person)

print('\n' + 60*'#')
print('get a list of all data file hashes for the first project in project_hash_list')
if project_hash_list:
    df_hash_list = api.data_files(project=project_hash_list[0])
    print('df_hash_list[:5]:', '\n\t', df_hash_list[:5])

print('\n' + 60*'#')
print('get a list of all data file hashes for the first person in people_hash_list')
if people_hash_list:
    df_hash_list = api.data_files(person=people_hash_list[0])
    print('df_hash_list[:5]:', '\n\t', df_hash_list[:5])

print('\n' + 60*'#')
print('get a list of all data file hashes modified within the last 7 days')
dt_last_week = datetime.now() - timedelta(days=7)
df_hash_list = api.data_files(time_m=dt_last_week)
print('df_hash_list[:5]:', '\n\t', df_hash_list[:5])

print('\n' + 60*'#')
print('get meta data of the first df_hash')
if df_hash_list:
    df_meta = api.data_file_meta(df_hash_list[0])
    print('df_meta:', '\n\t', df_meta)

print('\n' + 60*'#')
print('get data of the first df_hash')
if df_hash_list:
    df_data_hr = api.data_file_data(df_hash_list[0], 'heart_rate')
    print('df_data_hr["x"][:10]:', '\n\t', df_data_hr['x'][:10])
    print('df_data_hr["y"][:10]:', '\n\t', df_data_hr['y'][:10])
    df_data_ppg_ir = api.data_file_data(df_hash_list[0], 'ppg_ir')
    print('df_data_ppg_ir["x"][:10]:', '\n\t', df_data_ppg_ir['x'][:10])
    print('df_data_ppg_ir["y"][:10]:', '\n\t', df_data_ppg_ir['y'][:10])

print('\n' + 60*'#')
print('get chunk_data of the first df_hash')
if df_hash_list:
    df_chunk_data = api.data_file_data_by_chunk(df_hash_list[0])
    print('df_chunk_data:', '\n\t', df_chunk_data)

print('\n' + 60*'#')
print('get chunk_data of the first df_hash (option 2)')
if df_hash_list:
    df_chunk_data = api.data_file_chunks(df_hash_list[0])
    print('df_chunk_data[0]:', '\n\t', df_chunk_data[0])

print('\n' + 60*'#')
print('get vital data for the first person in people_hash_list')
if people_hash_list:
    vitals = api.vitals(person=people_hash_list[0])
    print('vitals:', '\n\t', vitals)

print('\n' + 60*'#')
print('get person_events')
print('loop person_events')
for person_event in api.person_events(project=project_hash_list[0])[:5]:
    print('\t', person_event)

print('\n' + 60*'#')
print('get observations')
print('loop observations')
for observation in api.observations(project=project_hash_list[0])[:5]:
    print('\t', observation)

