#!/usr/bin/env python3

from datetime import datetime, timedelta
import json
from pathlib import Path
import os
import sys
import pandas as pd
from cosinuss.api_client import APIClient

# ##########################################
# CONFIG
username = 'user.account'
project_hash = 'DJSY'
data_path = Path('data_export')
#data_types = ["heart_rate", "rr_int", "spo2", "acc_x", "acc_y", "acc_z", "ppg_ir", "ppg_red", "ppg_green",
#                "battery", "temperature", "perfusion_ir", "quality", "respiration_rate", "ppg_med",
#                "temperature_ct", "blood_pressure_sys", "blood_pressure_dia", "O2"]

# specify which data types must be downloaded
data_types = ['heart_rate', 'spo2', 'ppg_ir']
#data_types = ['heart_rate']
# ##########################################

def get_noon_time(dt):
    # define day break at noon 12:00
    if dt.hour < 12:
        return (dt - timedelta(days=1)).date()
    else:
        return dt.date()

# create api with username and password
#api = APIClient(username=username, password=password)
# create api with username only (password prompt)
api = APIClient(username=username)

person_hash_list = api.people(project=project_hash)
for j, person_hash in enumerate(person_hash_list):

    print(f'downloading data [{j+1}/{len(person_hash_list)}] for person {person_hash}')
    person_path = data_path / Path(person_hash)
    if not person_path.exists():
        # create target folders
        person_path.mkdir(parents=True)

    person_meta = api.person_meta(person=person_hash)
    json.dump(person_meta, open(f'{person_path / person_hash}_meta.json', 'w'), default=str, indent=4)

    print('\t', 'downloading person_events')
    person_events = api.person_events(person=person_hash)
    json.dump(person_events, open(f'{person_path / person_hash}_events.json', 'w'), default=str, indent=4)
    #for person_event in person_events:
    #    time_c = person_event['time'].split('.')[0].replace(' ', 'T').replace(':', '')
    #    json.dump(person_event, open(f'{person_path / person_hash}_event_{time_c}.json', 'w'), default=str, indent=4)

    print('\t', 'downloading observations')
    observations = api.observations(person=person_hash)
    json.dump(observations, open(f'{person_path / person_hash}_observations.json', 'w'), default=str, indent=4)
    #for observation in observations:
    #    time_c = observation['time_c'].split('.')[0].replace(' ', 'T').replace(':', '')
    #    json.dump(observation, open(f'{person_path / person_hash}_obs_{time_c}.json', 'w'), default=str, indent=4)
    
    df_dict = {}

    print('\t', 'downloading data files')
    df_hash_list = api.data_files(person=person_hash)
    for i, df_hash in enumerate(df_hash_list):
        df_meta = api.data_file_meta(df_hash)
        try:
            dt_start = datetime.strptime(df_meta['date_time_start'], '%Y-%m-%d %H:%M:%S.%f%z')
        except ValueError:
            dt_start = datetime.strptime(df_meta['date_time_start'], '%Y-%m-%d %H:%M:%S%z')
        dt_start_str = dt_start.strftime('%Y-%m-%dT%H%M%S')
        file_path_prefix = f'{person_path / person_hash}_df_{dt_start_str}'
        json.dump(df_meta, open(f'{file_path_prefix}_meta.json', 'w'), default=str, indent=4)
        for dt in data_types:
            if dt not in df_dict:
                df_dict[dt] = []
            print('\t', f'downloading [{i+1}/{len(df_hash_list)}] {df_hash} {dt}', end='\r')
            df_data = api.data_file_data(df_hash, dt)
            if df_data is None or df_data is False:
                sys.exit(f'ERROR in downloading {df_hash} {dt}')
            # store as csv
            if 'x' in df_data and df_data['x']:
                data_len = min(len(df_data['x']), len(df_data['y']))
                x_dt = dt_start + pd.to_timedelta(df_data['x'][:data_len], unit='s')
                x_dt = pd.Series(x_dt)
                #x_dt_naive = x_dt.dt.tz_convert('UTC').dt.tz_localize(None)
                x_dt_naive = x_dt.dt.tz_localize(None)
                df_dict[dt].append(pd.DataFrame({'time': x_dt_naive, dt: df_data['y'][:data_len]}))
                #csv_data = pd.DataFrame({'time': x_dt_naive, dt: df_data['y'][:data_len]})
                #csv_data.to_csv(f'{file_path_prefix}_{dt}.csv', index=False)
            print('\t', 60*' ', end='\r')
        #df_chunk_data = api.data_file_chunks(df_hash)
        #json.dump(df_chunk_data, open(f'{file_path_prefix}_chunk_data.json', 'w'), default=str, indent=4)
    
    # export csv files
    for dt in df_dict:
        print('\t', f'exporting csv files {dt}')
        
        # sorted concat df
        df_sorted = sorted(df_dict[dt], key=lambda df: df['time'].iloc[0])
        if not df_sorted:
            continue
        df_concat = pd.concat(df_sorted).reset_index(drop=True)

        # Create a new column noon_time for day breaks
        df_concat['noon_time'] = df_concat['time'].apply(get_noon_time)
        # Split the DataFrame based on noon time
        split_dataframes = []
        for noon_time, group in df_concat.groupby('noon_time'):
            day_df = pd.DataFrame(group)
            split_dataframes.append(day_df)

        for i, day_df in enumerate(split_dataframes):
            day_str = day_df['noon_time'].iloc[0]
            file_path = f'{person_path / person_hash}_df_{day_str}_{dt}.csv'
            print('\t', f'exporting [{i+1}/{len(split_dataframes)}] {file_path}', end='\r')
            day_df = day_df.drop(columns=['noon_time'])
            day_df.to_csv(file_path, index=False)
            print('\t', 80*' ', end='\r')




