#!/usr/bin/env python3

from datetime import datetime, timedelta
import json
from pathlib import Path
import os
import pandas as pd
from cosinuss.api_client import APIClient

# ##########################################
# CONFIG
username = 'user.account'
project_hash = '6QP3'
data_path = Path('data_export')
#data_types = ["heart_rate", "rr_int", "spo2", "acc_x", "acc_y", "acc_z", "ppg_ir", "ppg_red", "ppg_green",
#                "battery", "temperature", "perfusion_ir", "quality", "respiration_rate", "ppg_med",
#                "temperature_ct", "blood_pressure_sys", "blood_pressure_dia", "O2"]

# specify which data types must be downloaded
data_types = ['heart_rate', 'spo2', 'ppg_ir']
# ##########################################

# create api with username and password
#api = APIClient(username=username, password=password)
# create api with username only (password prompt)
api = APIClient(username=username)

for person_hash in api.people(project=project_hash):

    print(f'downloading data for person {person_hash}')
    person_path = data_path / Path(person_hash)
    if not person_path.exists():
        # create target folders
        person_path.mkdir(parents=True)

    person_meta = api.person_meta(person=person_hash)
    json.dump(person_meta, open(f'{person_path / person_hash}_meta.json', 'w'), default=str, indent=4)

    print('\t', 'downloading person_events')
    person_events = api.person_events(person=person_hash)
    json.dump(person_events, open(f'{person_path / person_hash}_events.json', 'w'), default=str, indent=4)
    #for person_event in person_events:
    #    time_c = person_event['time'].split('.')[0].replace(' ', 'T').replace(':', '')
    #    json.dump(person_event, open(f'{person_path / person_hash}_event_{time_c}.json', 'w'), default=str, indent=4)

    print('\t', 'downloading observations')
    observations = api.observations(person=person_hash)
    json.dump(observations, open(f'{person_path / person_hash}_observations.json', 'w'), default=str, indent=4)
    #for observation in observations:
    #    time_c = observation['time_c'].split('.')[0].replace(' ', 'T').replace(':', '')
    #    json.dump(observation, open(f'{person_path / person_hash}_obs_{time_c}.json', 'w'), default=str, indent=4)

    print('\t', 'downloading data files')
    for df_hash in api.data_files(person=person_hash):
        df_meta = api.data_file_meta(df_hash)
        dt_start = df_meta['date_time_start'].split('.')[0].replace(' ', 'T').replace(':', '')
        file_path_prefix = f'{person_path / person_hash}_df_{dt_start}'
        json.dump(df_meta, open(f'{file_path_prefix}_meta.json', 'w'), default=str, indent=4)
        for dt in data_types:
            print('\t', f'downloading {df_hash} {dt}', end='\r')
            df_data = api.data_file_data(df_hash, dt)
            # store as csv
            if 'x' in df_data and df_data['x']:
                data_len = min(len(df_data['x']), len(df_data['y']))
                csv_data = pd.DataFrame({'x': df_data['x'][:data_len], 'y': df_data['y'][:data_len]})
                csv_data.to_csv(f'{file_path_prefix}_{dt}.csv', index=False)
            print('\t', 60*' ', end='\r')
        df_chunk_data = api.data_file_chunks(df_hash)
        json.dump(df_chunk_data, open(f'{file_path_prefix}_chunk_data.json', 'w'), default=str, indent=4)




